/*****************************************************************************
* This  file is used to configure RF4CE Applications. Normally set
* through BeeKit (called properties), but can be edited manually. A new export
* from BeeKit will overwrite this file.
*
* (c) Copyright 2008, Freescale, Inc. All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
*****************************************************************************/

#ifndef _APPLICATION_CONFIG_H_
#define _APPLICATION_CONFIG_H_

#include "EmbeddedTypes.h"
#include "NwkInterface.h"


/*****************************************************************************
******************************************************************************
* Public macros
******************************************************************************
*****************************************************************************/

/*
  This property describes the extended address for this node. The extended
  address, also called IEEE address, long address or 64-bit MAC addres, is a
  world-wide unique identifier. Google "IEEE OUI" for a discussion of this
  address, and to purchase a range of addresses from IEEE. The MAC address
  MUST be unique per node.

  This, as with all multi-byte fields, is little endian:
  For example MAC (aka IEEE or extended) address 0x0050c237b0010202 would be
  0x02,0x02,0x01,0xb0,0x37,0xc2,0x50,0x00

  Default: 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

*/
#ifndef gDefaultValueOfExtendedAddress_c
#define gDefaultValueOfExtendedAddress_c		            0x00,0x00,0x00,0x00,0x00,0xC2,0x50,0x00
#endif

#ifndef gDefaultValueOfNodeType_c
#define gDefaultValueOfNodeType_c                       gNodeTypeController_c
#endif

#ifndef gDefaultValueOfCapabPowerSource_c
#define gDefaultValueOfCapabPowerSource_c               FALSE
#endif

#ifndef gDefaultValueOfCapabSecurity_c
#define gDefaultValueOfCapabSecurity_c                  TRUE
#endif

#ifndef gDefaultValueOfCapabChannelNormalization_c
#define gDefaultValueOfCapabChannelNormalization_c      TRUE
#endif

#ifndef gDefaultValueOfVendorId_c
#define gDefaultValueOfVendorId_c                       {0x05,0x00}
#endif

#ifndef gDefaultValueOfVendorString_c
#define gDefaultValueOfVendorString_c                   "VENDOR"
#endif

#ifndef gDefaultValueOfFrameCounterWindow_c
#define gDefaultValueOfFrameCounterWindow_c             1024
#endif

#ifndef gLpmIncluded_d
#define gLpmIncluded_d                                  TRUE
#endif


/*****************************************************************************
******************************************************************************
* Public type definitions
******************************************************************************
*****************************************************************************/


/*****************************************************************************
******************************************************************************
* Public prototypes
******************************************************************************
*****************************************************************************/



#endif /* _APPLICATION_CONFIG_H_ */
